#include <drive/backend/processors/users/processor.h>

namespace NDrivematics {
    class TDMUserForceDeletionProcessor
        : public TAppCommonRegistrator<TDMUserForceDeletionProcessor, TEmptyConfig>
        , public TBaseUserForceDeletionProcessor
    {
    private:
        using TBase = TAppCommonRegistrator<TDMUserForceDeletionProcessor, TEmptyConfig>;

    public:
        TDMUserForceDeletionProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
            : TBase(config)
            , TBaseUserForceDeletionProcessor(config, context, authModule, server)
        {
        }

        static TString GetTypeName() {
            return "dm_organization_user_force_delete";
        }

        virtual void DoCheckDeletePermissions(const TString& userId, TUserPermissions::TPtr permissions) const override;
    };
}
