#include <drive/backend/processors/users/processor.h>

namespace NDrivematics {
    class TDMUserInfoEditingProcessor
        : public TAppCommonRegistrator<TDMUserInfoEditingProcessor, TEmptyConfig>
        , public TBaseUserInfoEditingProcessor
    {
    private:
        using TBase = TAppCommonRegistrator<TDMUserInfoEditingProcessor, TEmptyConfig>;

    public:
        TDMUserInfoEditingProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
            : TBase(config)
            , TBaseUserInfoEditingProcessor(config, context, authModule, server)
        {
        }

        static TString GetTypeName() {
            return "dm_organization_user_edit";
        }

        virtual void DoCheckEditPermissions(const TString& userId, TUserPermissions::TPtr permissions) const override;
    };
}
