#pragma once

#include <drive/backend/drivematics/signals/description.h>
#include <drive/backend/processors/common_app/processor.h>

namespace NDrive {
    class TGetSignalsProcessor : public TAppCommonProcessor<TGetSignalsProcessor> {
    private:
        using TBase = TAppCommonProcessor<TGetSignalsProcessor>;

    public:
        using TBase::TBase;

        static TString GetTypeName() {
            return "get_signals";
        }

    private:
        virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

        void Process1(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions);
        void Process2(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions);

    public:
        const static inline TString SignalsDescriptionSettingName = "leasing.signals_description";
    };

    class TGetSignalsDescriptionsProcessor : public TAppCommonProcessor<TGetSignalsDescriptionsProcessor> {
    private:
        using TBase = TAppCommonProcessor<TGetSignalsDescriptionsProcessor>;

    public:
        using TBase::TBase;

        static TString GetTypeName() {
            return "get_signals_descriptions";
        }

    private:
        virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };
}
