#include "login_subrequest.h"

#include <drive/backend/tags/tags_manager.h>

#include <drive/library/cpp/network/data/data.h>

#include <library/cpp/http/misc/httpcodes.h>

void TLeasingLoginSubrequestProcessor2::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /* requestData */) {
    TString leasingRoleName = Server->GetSettings().GetValueDef<TString>("leasing_cabinet.admin_role_name", "leasing_admin");
    TString insufficientRolesTagName = Server->GetSettings().GetValueDef<TString>("leasing_cabinet.insufficient_roles_tag_name", "insufficient_roles_tag");
    const auto& api = *Yensured(Server->GetDriveAPI());
    TVector<TString> result;
    const auto& usersData = *Yensured(api.GetUsersData());
    bool usersFetched = usersData.GetRoles().GetUsersWithRoles({ leasingRoleName }, result, true);
    R_ENSURE(usersFetched, HTTP_INTERNAL_SERVER_ERROR, "can't restore users with given role");
    auto userId = permissions->GetUserId();
    auto it = std::find(result.begin(), result.end(), userId);
    if (it == result.end()) {
        auto tx = BuildTx<NSQL::Writable>();
        auto tag = api.GetTagsManager().GetTagsMeta().CreateTag(insufficientRolesTagName);
        R_ENSURE(tag, HTTP_INTERNAL_SERVER_ERROR, "can't create tag");
        R_ENSURE(api.GetTagsManager().GetUserTags().AddTag(tag, userId, userId, Server, tx, EUniquePolicy::SkipIfExists), HTTP_INTERNAL_SERVER_ERROR, "can't add tag", tx);
        R_ENSURE(tx.Commit(), HTTP_INTERNAL_SERVER_ERROR, "can't commit transaction", tx);
        R_ENSURE(it != result.end(), HTTP_FORBIDDEN, "insufficient roles");
    }
    g.SetCode(HTTP_OK);
}
