#pragma once

#include <drive/backend/processors/common_app/db_entities.h>

#include <drive/backend/notifications/manager.h>

class TNotifiersCompanyAddProcessor: public TAppCommonProcessor<TNotifiersCompanyAddProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TNotifiersCompanyAddProcessor, TEmptyConfig>;
    
protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::Notifier;
    }
public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "notifiers_company_add";
    }
};

class TNotifiersCompanyListProcessor: public TAppCommonProcessor<TNotifiersCompanyListProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TNotifiersCompanyListProcessor, TEmptyConfig>;
    
protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::Notifier;
    }
public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "notifiers_company_list";
    }
};

class TNotifiersCompanyRemoveProcessor: public TAppCommonProcessor<TNotifiersCompanyRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TNotifiersCompanyRemoveProcessor, TEmptyConfig>;
    
protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::Notifier;
    }
public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "notifiers_company_remove";
    }
};

class TNotifiersCompanyModifyProcessor: public TAppCommonProcessor<TNotifiersCompanyModifyProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TNotifiersCompanyModifyProcessor, TEmptyConfig>;
    
protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::Notifier;
    }
public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "notifiers_company_modify";
    }
};
