#include "remove_signal.h"
#include "common.h"

#include <drive/backend/data/leasing/company.h>
#include <drive/backend/drivematics/signals/signal_configurations.h>
#include <drive/backend/rt_background/manager/manager.h>

namespace NDrivematics {
    void TRemoveSignalProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) {
        ReqCheckAdmActions(permissions, TAdministrativeAction::EAction::Remove, TAdministrativeAction::EEntity::SignalConfiguration);
        auto force = GetValue<bool>(Context->GetCgiParameters(), "force", false).GetOrElse(false);


        auto tx = BuildTx<NSQL::Writable>();
        const auto& api = *Yensured(Server->GetDriveAPI());

        auto acl = NDrivematics::TACLTag::GetACLTag(permissions, tx, *Server);
        auto aclCompany = acl->GetCompanyTagDescription(permissions->GetUserId(), *Server);

        auto signalName = GetString(requestData, "signal_name", true);

        auto affiliatedCompanyTagDescription = TUserOrganizationAffiliationTag::GetAffiliatedCompanyTagDescription(permissions->GetUserId(), *Server, tx);
        TMaybe<TVector<TSignalConfigurationDB>> signalsConfiguraions = Server->GetDriveAPI()->GetSignalsConfigurationsDB()->GetObjects(std::dynamic_pointer_cast<const TTagDescription>(affiliatedCompanyTagDescription), tx);
        R_ENSURE(!!signalsConfiguraions, {}, "can't get signals configurations", tx);

        auto signalIt = std::find_if(signalsConfiguraions->begin(), signalsConfiguraions->end(), [&signalName](const TSignalConfigurationDB& sig){
            if (sig->GetSignalName() == signalName) {
                return true;
            }
            return false;
        });
        R_ENSURE(signalIt != signalsConfiguraions->end(), {}, "can't found signal", tx);
        R_ENSURE(aclCompany->RemoveEntityObjects(TAdministrativeAction::EEntity::SignalConfiguration, {signalIt->GetInternalId()}, permissions, Server, tx), {}, "no such signal name from ACL tag "  << signalName, tx);

        auto& signalConfigurationPtr = *signalIt;
        auto backgroundProcessesNames = signalConfigurationPtr->GetBackgroundProcessesNames();
        TMap<TString, TRTBackgroundProcessContainer> settings;
        Y_UNUSED(Server->GetRTBackgroundManager()->GetSettingsInfo(&tx, settings, MakeSet(backgroundProcessesNames)));
        if (settings.size() == backgroundProcessesNames.size() || !force) {
            R_ENSURE(Server->GetRTBackgroundManager()->RemoveBackground(backgroundProcessesNames, permissions->GetUserId(), tx), {}, "can't remove processes", tx);
        }
        R_ENSURE(api.GetTagsManager().GetTagsMeta().RegisterTag(aclCompany, permissions->GetUserId(), tx), {}, "cannot update tag description", tx);
        R_ENSURE(tx.Commit(), {}, "can't commit session", tx);
        g.SetCode(HTTP_OK);
    }
}
