#pragma once

#include <drive/backend/offers/offers/standart.h>
#include <drive/backend/database/transaction/assert.h>
#include <drive/backend/data/chargable.h>
#include <drive/backend/database/drive_api.h>

namespace NDrivematics {

class TContext {
public:
    using TPtr = TAtomicSharedPtr<TContext>;

private:
    R_FIELD(TString, CarId);
    R_FIELD(TDBTag, ChargableTag);
    R_FIELD(TInstant, LastUpdatedAt, TInstant::Zero());
    R_FIELD(TString, SessionId);

    R_FIELD(NJson::TJsonValue, Report);

public:
    TContext() = delete;

    TContext(const TString& carId, TDBTag&& chargableTag)
        : CarId(carId)
        , ChargableTag(std::move(chargableTag))
    {
    }

    bool AddReport(TStringBuf name, NJson::TJsonValue&& elem) {
        return Report.SetValueByPath(name, std::move(elem));
    }

    bool AddErrorReport(TStringBuf name, NJson::TJsonValue&& elem) {
        return Report.SetValueByPath(TStringBuilder() << "error." << name, std::move(elem));
    }

    NJson::TJsonValue GetErrorReport() const {
        return Report["error"].GetStringRobust();
    }
};

bool CreateSession(TContext::TPtr context, TUserPermissions::TPtr permissions, const NDrive::IServer& server, NDrive::TEntitySession& tx, const TString& settingName);
bool SwitchToRiding(TContext::TPtr context, TUserPermissions::TPtr permissions, const NDrive::IServer& server, NDrive::TEntitySession& tx);
bool SwitchToParking(TContext::TPtr context, TUserPermissions::TPtr permissions, const NDrive::IServer& server, NDrive::TEntitySession& tx);
bool SwitchToReservation(TContext::TPtr context, TUserPermissions::TPtr permissions, const NDrive::IServer& server, NDrive::TEntitySession& tx);
bool IsOldTimestamp(TContext::TPtr context, TInstant timestamp, const TDeviceTagsManager& tagManager, NDrive::TEntitySession& tx);
bool ProcessTaxiOffer(TContext::TPtr context, TUserPermissions::TPtr permissions,
                      const NDrive::IServer& server, NDrive::TEntitySession& tx,
                      const TDBTag& restoredTag, bool isTaxiSession, bool engineOn);
TDBTag GetRestoredTag(const TString& carId, TConstArrayRef<TString> tagNames, const TDeviceTagsManager& tagManager, NDrive::TEntitySession& tx);
bool CloseSignalqSession(const ISession::TPtr session, const TString& userId, const NDrive::IServer& server, bool dryRun = false);
TUserPermissions::TPtr GetLinkedOperatorPermissions(const TString& carId, const NDrive::IServer& server, NDrive::TEntitySession& session);
}
