#include "set_brand_tins.h"

#include <drive/backend/data/leasing/leasing.h>

void TSetBrandTinsProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) {
    const TMaybe<TString> brandName = GetValue<TString>(requestData, "brand", true);
    R_ENSURE(brandName, HTTP_BAD_REQUEST, "no 'brand' field in the input");
    TVector<ui64> taxiCompaniesTins = GetValues<ui64>(requestData, "taxi_companies_tins", true);
    const auto& api = *Yensured(Yensured(Server)->GetDriveAPI());
    auto session = BuildTx<NSQL::Writable>();

    ITagsMeta::TTagDescriptionsByName tags = api.GetTagsManager().GetTagsMeta().GetRegisteredTags(NEntityTagsManager::EEntityType::Car, { NDrivematics::TBrandTag::TypeName });
    auto it = std::find_if(tags.begin(), tags.end(), [&brandName](const auto& element) {
        auto tagDesc = std::dynamic_pointer_cast<const NDrivematics::TBrandTag::TDescription>(element.second);
        R_ENSURE(tagDesc, HTTP_INTERNAL_SERVER_ERROR, "can't cast tag description");
        return tagDesc->GetBrandName() == *brandName;
    });
    R_ENSURE(it != tags.end(), HTTP_BAD_REQUEST, "can't find brand with name '" << *brandName << "'");
    auto tagDesc = std::dynamic_pointer_cast<NDrivematics::TBrandTag::TDescription>(it->second->Clone());
    R_ENSURE(tagDesc, HTTP_INTERNAL_SERVER_ERROR, "can't cast tag description");
    for (ui64 tin : taxiCompaniesTins) {
        tagDesc->MutableTaxiCompaniesTins().push_back(ToString(tin));
    }
    R_ENSURE(api.GetTagsManager().GetTagsMeta().RegisterTag(tagDesc, permissions->GetUserId(), session), {}, "cannot update tag description", session);
    R_ENSURE(session.Commit(), {}, "cannot commit session", session);
    g.SetCode(HTTP_OK);
}
