#include "switch_signal.h"
#include "common.h"

#include <drive/backend/data/leasing/company.h>
#include <drive/backend/drivematics/signals/signal_configurations.h>
#include <drive/backend/rt_background/manager/manager.h>

namespace NDrivematics {
    void TSwitchSignalProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) {
        ReqCheckAdmActions(permissions, TAdministrativeAction::EAction::Modify, TAdministrativeAction::EEntity::SignalConfiguration);
        auto signalName = GetString(requestData, "signal_name", true);

        auto tx = BuildTx<NSQL::Writable>();
        const auto& api = *Yensured(Server->GetDriveAPI());

        auto affiliatedCompanyTagDescription = TUserOrganizationAffiliationTag::GetAffiliatedCompanyTagDescription(permissions->GetUserId(), *Server, tx);
        TMaybe<TVector<TSignalConfigurationDB>> signalsConfigurations = api.GetSignalsConfigurationsDB()->GetObjects(affiliatedCompanyTagDescription, tx);
        R_ENSURE(!!signalsConfigurations, {}, "can't get signals configurations", tx);
        auto it = std::find_if(signalsConfigurations->begin(), signalsConfigurations->end(), [&signalName](const TSignalConfigurationDB& confDB) {
            return confDB->GetSignalName() == signalName;
        });
        R_ENSURE(it != signalsConfigurations->end(), HTTP_BAD_REQUEST, "no such signal name: " << signalName);

        auto& signalConfigurationPtr = *it;
        TMap<TString, TRTBackgroundProcessContainer> containers;
        R_ENSURE(Server->GetRTBackgroundManager()->GetSettingsInfo(&tx, containers, MakeSet(signalConfigurationPtr->GetBackgroundProcessesNames())), {}, "can't restore processes", tx);

        bool isEnabled = signalConfigurationPtr->GetIsEnabled();
        isEnabled = !isEnabled;
        signalConfigurationPtr->SetIsEnabled(isEnabled);
        R_ENSURE(api.GetSignalsConfigurationsDB()->UpsertObject(signalConfigurationPtr, permissions->GetUserId(), tx), {}, "can't upsert changes to storage", tx);

        for (auto& [_, container] : containers) {
            container.GetProcessSettings()->SetEnabled(isEnabled);
            R_ENSURE(Server->GetRTBackgroundManager()->UpsertObject(container, permissions->GetUserId(), tx), {}, "can't upsert robot", tx);
        }
        R_ENSURE(tx.Commit(), {}, "can't commit session", tx);
        g.SetCode(HTTP_OK);
    }
}
