#pragma once

#include <drive/backend/processors/common_app/processor.h>
#include <drive/backend/drivematics/zone/zone.h>

class TZoneAddProcessor: public TAppCommonProcessor<TZoneAddProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TZoneAddProcessor, TEmptyConfig>;
public:
    TZoneAddProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "zone_add";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    static TAdministrativeAction::EEntity GetEntityType() {
        return TAdministrativeAction::EEntity::Zone;
    }
};

class TZoneRemoveProcessor: public TAppCommonProcessor<TZoneRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TZoneRemoveProcessor, TEmptyConfig>;
public:
    TZoneRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "zone_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    static TAdministrativeAction::EEntity GetEntityType() {
        return TAdministrativeAction::EEntity::Zone;
    }
};

class TZoneGetProcessor: public TAppCommonProcessor<TZoneGetProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TZoneGetProcessor, TEmptyConfig>;
public:
    TZoneGetProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "zone_get";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    static TAdministrativeAction::EEntity GetEntityType() {
        return TAdministrativeAction::EEntity::Zone;
    }
};

class TZoneUpsertProcessor: public TAppCommonProcessor<TZoneUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TZoneUpsertProcessor, TEmptyConfig>;
public:
    TZoneUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "zone_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    static TAdministrativeAction::EEntity GetEntityType() {
        return TAdministrativeAction::EEntity::Zone;
    }
};
