#pragma once

#include "config.h"

#include <drive/backend/localization/localization.h>
#include <drive/backend/processors/common_app/db_entities.h>
#include <drive/backend/processors/common_app/processor.h>

class TLocalizationInfoProcessor: public TAppCommonProcessor<TLocalizationInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TLocalizationInfoProcessor, TEmptyConfig>;
public:
    TLocalizationInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "localization_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TLocalizationUpsertProcessor : public TAppCommonProcessor<TLocalizationUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TLocalizationUpsertProcessor, TEmptyConfig>;
public:
    TLocalizationUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "localization_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TLocalizationRemoveProcessor : public TAppCommonProcessor<TLocalizationRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TLocalizationRemoveProcessor, TEmptyConfig>;
public:
    TLocalizationRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "localization_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TLocalizationPropositionsProcessor: public TPropositionsListProcessor<NLocalization::TResource, TLocalizationPropositionsProcessor> {
private:
    using TBase = TPropositionsListProcessor<NLocalization::TResource, TLocalizationPropositionsProcessor>;

public:
    using TBase::TBase;

protected:
    virtual const IDBEntitiesWithPropositionsManager<NLocalization::TResource>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return dynamic_cast<const NLocalization::TLocalizationDB*>(server->GetLocalization());
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Localization;
    }
};

class TLocalizationProposeProcessor: public TObjectsProposeProcessor<NLocalization::TResource, TLocalizationProposeProcessor> {
private:
    using TBase = TObjectsProposeProcessor<NLocalization::TResource, TLocalizationProposeProcessor>;

public:
    using TBase::TBase;

protected:
    virtual const IDBEntitiesWithPropositionsManager<NLocalization::TResource>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return dynamic_cast<const NLocalization::TLocalizationDB*>(server->GetLocalization());
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Localization;
    }
};

class TLocalizationConfirmProcessor: public TObjectsConfirmProcessor<NLocalization::TResource, TLocalizationConfirmProcessor> {
private:
    using TBase = TObjectsConfirmProcessor<NLocalization::TResource, TLocalizationConfirmProcessor>;

public:
    using TBase::TBase;

protected:
    virtual const IDBEntitiesWithPropositionsManager<NLocalization::TResource>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return dynamic_cast<const NLocalization::TLocalizationDB*>(server->GetLocalization());
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Localization;
    }
};

class TLocalizationRejectProcessor: public TObjectsRejectProcessor<NLocalization::TResource, TLocalizationRejectProcessor> {
private:
    using TBase = TObjectsRejectProcessor<NLocalization::TResource, TLocalizationRejectProcessor>;

public:
    using TBase::TBase;

protected:
    virtual const IDBEntitiesWithPropositionsManager<NLocalization::TResource>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return dynamic_cast<const NLocalization::TLocalizationDB*>(server->GetLocalization());
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Localization;
    }
};
