#include "processor.h"

#include <drive/backend/logging/events.h>

void TLogPushProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) {
    Y_UNUSED(permissions);
    const auto& ev = GetString(requestData, "event");
    const auto& data = requestData["data"];
    R_ENSURE(data.IsDefined(), ConfigHttpStatus.UserErrorState, "data is undefined");
    NDrive::TEventLog::Log(ev, data);
    g.SetCode(HTTP_OK);
}
