#pragma once

#include "config.h"

#include <drive/backend/processors/common_app/processor.h>

class TMaintenanceInfoProcessor: public TAppCommonProcessor<TMaintenanceInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TMaintenanceInfoProcessor, TEmptyConfig>;
public:
    TMaintenanceInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "maintenance_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TMaintenanceUpsertProcessor: public TAppCommonProcessor<TMaintenanceUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TMaintenanceUpsertProcessor, TEmptyConfig>;
public:
    TMaintenanceUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "maintenance_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TMaintenanceRemoveProcessor: public TAppCommonProcessor<TMaintenanceRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TMaintenanceRemoveProcessor, TEmptyConfig>;
public:
    TMaintenanceRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "maintenance_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTyreServiceInfoProcessor : public TAppCommonProcessor<TTyreServiceInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTyreServiceInfoProcessor, TEmptyConfig>;
public:
    TTyreServiceInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "tyre_service_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTyreStorageInfoProcessor : public TAppCommonProcessor<TTyreStorageInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTyreStorageInfoProcessor, TEmptyConfig>;
public:
    TTyreStorageInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "tyre_storage_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TLastTyreServiceProcessor : public TAppCommonProcessor<TLastTyreServiceProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TLastTyreServiceProcessor, TEmptyConfig>;
public:
    TLastTyreServiceProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "last_tyre_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTyreFilesProcessor : public TAppCommonProcessor<TTyreFilesProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTyreFilesProcessor, TEmptyConfig>;
public:
    TTyreFilesProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "tyre_files";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

