#include "config.h"

void TMDSProcessorConfig::InitFeatures(const TYandexConfig::Section* section) {
    IsExternalApi = section->GetDirectives().Value("IsExternalApi", IsExternalApi);
    if (section->GetDirectives().contains("MaxFileSize")) {
        MaxFileSize = section->GetDirectives().Value("MaxFileSize", 0);
    }
    CheckIsImage = section->GetDirectives().Value("CheckIsImage", CheckIsImage);
}

void TMDSProcessorConfig::ToStringFeatures(IOutputStream& os) const {
    os << "IsExternalApi: " << IsExternalApi << Endl;
    if (MaxFileSize) {
        os << "MaxFileSize: " << *MaxFileSize << Endl;
    }
    os << "CheckIsImage: " << CheckIsImage << Endl;
}
