#pragma once

#include "config.h"

#include <drive/backend/processors/common_app/processor.h>

class TMDSBucketInfoProcessor: public TAppCommonProcessor<TMDSBucketInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TMDSBucketInfoProcessor, TEmptyConfig>;
public:
    TMDSBucketInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "mds_bucket_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TMDSUploadProcessor : public TAppCommonProcessor<TMDSUploadProcessor, TMDSProcessorConfig> {
private:
    using TBase = TAppCommonProcessor<TMDSUploadProcessor, TMDSProcessorConfig>;
public:
    TMDSUploadProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "mds_upload";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TMDSRemoveProcessor : public TAppCommonProcessor<TMDSRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TMDSRemoveProcessor, TEmptyConfig>;
public:
    TMDSRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "mds_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TMDSProxyProcessor : public TAppCommonProcessor<TMDSProxyProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TMDSProxyProcessor, TEmptyConfig>;
public:
    TMDSProxyProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "mds_proxy";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
