#pragma once

#include <drive/backend/processors/common_app/processor.h>

#include <drive/library/cpp/mediabilling/client.h>

template <class T>
class TMediaBillingBaseProcessor : public TAppCommonProcessor<T, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<T, TEmptyConfig>;

public:
    using TBase::TBase;

protected:
    const NDrive::TMediaBillingClient& GetClient() const {
        if (!Client) {
            auto deadline = TBase::Context->GetRequestDeadline();
            auto endpoint = TBase::template GetHandlerSetting<TString>("mediabilling.endpoint").GetOrElse(NDrive::MediaBillingProductionEndpoint);
            auto selfClientId = TBase::template GetHandlerSetting<NTvmAuth::TTvmId>("mediabilling.self_client_id").GetOrElse(0);
            auto tvm = selfClientId ? TBase::Server->GetTvmClient(selfClientId) : nullptr;
            NDrive::TMediaBillingClient::TOptions options;
            options.Endpoint = endpoint;
            options.DefaultTimeout = 0.9 * (deadline - Now());
            Client = MakeHolder<NDrive::TMediaBillingClient>(options, tvm);
        }
        return *Client;
    }

private:
    mutable THolder<NDrive::TMediaBillingClient> Client;
};

class TGetOrderInfoProcessor: public TMediaBillingBaseProcessor<TGetOrderInfoProcessor> {
private:
    using TBase = TMediaBillingBaseProcessor<TGetOrderInfoProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "mediabilling_get_order_info";
    }

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSubmitOrderProcessor: public TMediaBillingBaseProcessor<TSubmitOrderProcessor> {
private:
    using TBase = TMediaBillingBaseProcessor<TSubmitOrderProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "mediabilling_submit_order";
    }

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
