#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TAddOfferModelProcessor: public TAppCommonProcessor<TAddOfferModelProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TAddOfferModelProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "offer_model_add";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TGetOfferModelProcessor: public TAppCommonProcessor<TGetOfferModelProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TGetOfferModelProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "offer_model_get";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TListOfferModelProcessor: public TAppCommonProcessor<TListOfferModelProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TListOfferModelProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "offer_model_list";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRemoveOfferModelProcessor: public TAppCommonProcessor<TRemoveOfferModelProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRemoveOfferModelProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "offer_model_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
