#pragma once

#include <drive/backend/cars/car_model.h>
#include <drive/backend/cars/car.h>
#include <drive/backend/device_snapshot/snapshots/snapshot.h>
#include <drive/backend/processors/common_app/processor.h>
#include <drive/backend/processors/user_app/processor.h>

namespace NDrive {

    template<typename THandler,
            typename THandlerConfig = TEmptyConfig>
    class TMtProcessor : public TAppCommonProcessor<THandler, THandlerConfig> {
    private:
        using TBase = TAppCommonProcessor<THandler, THandlerConfig>;

    public:
        using TBase::TBase;

        TString GetOrigin() const override;

    protected:
        void ProcessException(TJsonReport::TGuard& g, const TCodedException& exception) const override;
    };

    class TMtTokenProcessor : public TMtProcessor<TMtTokenProcessor> {
    private:
        using TBase = TMtProcessor<TMtTokenProcessor>;

    public:
        using TBase::TBase;

        static TString GetTypeName();

        void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

    class TMtBookOfferProcessor : public TMtProcessor<TMtBookOfferProcessor> {
    private:
        using TBase = TMtProcessor<TMtBookOfferProcessor>;

    public:
        using TBase::TBase;

        static TString GetTypeName();

        void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

    class TMtCurrentRideProcessor : public TMtProcessor<TMtCurrentRideProcessor> {
    private:
        using TBase = TMtProcessor<TMtCurrentRideProcessor>;
    
    public:
        using TBase::TBase;

        static TString GetTypeName();

        void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

    class TMtRideProcessor : public TMtProcessor<TMtRideProcessor> {
    private:
        using TBase = TMtProcessor<TMtRideProcessor>;
    
    public:
        using TBase::TBase;

        static TString GetTypeName();

        void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

    class TMtCancelRideProcessor : public TMtProcessor<TMtCancelRideProcessor, TEvolveConfig> {
    private:
        using TBase = TMtProcessor<TMtCancelRideProcessor, TEvolveConfig>;

    public:
        using TBase::TBase;

        static TString GetTypeName();

        void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

    class TMtCarCardProcessor : public TMtProcessor<TMtCarCardProcessor> {
    private:
        using TBase = TMtProcessor<TMtCarCardProcessor>;
    
    public:
        using TBase::TBase;

        static TString GetTypeName();

        void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

    class TMtZonesProcessor : public TMtProcessor<TMtZonesProcessor> {
    private:
        using TBase = TMtProcessor<TMtZonesProcessor>;
    
    public:
        using TBase::TBase;

        static TString GetTypeName();

        void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

    class TMtPolicyProcessor : public TMtProcessor<TMtPolicyProcessor> {
    private:
        using TBase = TMtProcessor<TMtPolicyProcessor>;
    
    public:
        using TBase::TBase;

        static TString GetTypeName();

        void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    };

}
