#pragma once

#include <drive/backend/processors/common_app/config.h>
#include <drive/backend/processors/common_app/db_entities.h>
#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/database/drive/named_filters.h>

class TNamedFiltersAddProcessor: public TAppCommonProcessor<TNamedFiltersAddProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TNamedFiltersAddProcessor, TEmptyConfig>;
public:
    TNamedFiltersAddProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "named_filters_add";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::NamedFilter;
    }
    const IDBEntitiesManager<TNamedFilter>* GetEntitiesManager(const IServerBase* server) const {
        return server->GetAsSafe<NDrive::IServer>().GetDriveAPI()->GetNamedFiltersDB();
    }
};

template <class THandler>
class TRemoveACLObjectsProcessor: public TAppCommonProcessor<THandler, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<THandler, TEmptyConfig>;
    using THandlerConfig = TContextAwareConfig<THandler, TEmptyConfig, TSchemeReportingProcessor<THandler>>;
public:
    TRemoveACLObjectsProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    virtual TAdministrativeAction::EEntity GetEntityType() const = 0;
};

class TNamedFiltersRemoveProcessor: public TRemoveACLObjectsProcessor<TNamedFiltersRemoveProcessor> {
private:
    using TBase = TRemoveACLObjectsProcessor<TNamedFiltersRemoveProcessor> ;
public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "named_filters_remove";
    }

private:
    TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::NamedFilter;
    }
};

class TNamedFiltersUpsertProcessor: public TAppCommonProcessor<TNamedFiltersUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TNamedFiltersUpsertProcessor, TEmptyConfig>;
public:
    TNamedFiltersUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "named_filters_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

    void UpsertObjects(const bool force, const TVector<TNamedFilter>& containers, TUserPermissions::TPtr permissions, NDrive::TEntitySession& session) const;

private:
    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::NamedFilter;
    }

    const IDBEntitiesManager<TNamedFilter>* GetEntitiesManager(const IServerBase* server) const {
        return server->GetAsSafe<NDrive::IServer>().GetDriveAPI()->GetNamedFiltersDB();
    }
};

class TNamedFiltersGetProcessor: public TAppCommonProcessor<TNamedFiltersGetProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TNamedFiltersGetProcessor, TEmptyConfig>;
public:
    TNamedFiltersGetProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "named_filters_get";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::NamedFilter;
    }
};

class TStaticFiltersAddProcessor: public TAppCommonProcessor<TStaticFiltersAddProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStaticFiltersAddProcessor, TEmptyConfig>;
public:
    TStaticFiltersAddProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "static_filters_add";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::Tag;
    }
    const ITagsMeta& GetEntitiesManager(const IServerBase* server) const {
        return server->GetAsSafe<NDrive::IServer>().GetDriveAPI()->GetTagsManager().GetTagsMeta();
    }
};

class TStaticFiltersRemoveProcessor: public TRemoveACLObjectsProcessor<TStaticFiltersRemoveProcessor> {
private:
    using TBase = TRemoveACLObjectsProcessor<TStaticFiltersRemoveProcessor>;
public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "static_filters_remove";
    }

private:
    TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Tag;
    }
};

class TStaticFiltersUpsertProcessor: public TAppCommonProcessor<TStaticFiltersUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStaticFiltersUpsertProcessor, TEmptyConfig>;
public:
    TStaticFiltersUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "static_filters_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::Tag;
    }
    const ITagsMeta& GetEntitiesManager(const IServerBase* server) const {
        return server->GetAsSafe<NDrive::IServer>().GetDriveAPI()->GetTagsManager().GetTagsMeta();
    }
};

class TStaticFiltersGetProcessor: public TAppCommonProcessor<TStaticFiltersGetProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStaticFiltersGetProcessor, TEmptyConfig>;
public:
    TStaticFiltersGetProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "static_filters_get";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::Tag;
    }
    const ITagsMeta& GetEntitiesManager(const IServerBase* server) const {
        return server->GetAsSafe<NDrive::IServer>().GetDriveAPI()->GetTagsManager().GetTagsMeta();
    }
};

class TStaticFiltersGetObjectsProcessor: public TAppCommonProcessor<TStaticFiltersGetObjectsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStaticFiltersGetObjectsProcessor, TEmptyConfig>;
public:
    TStaticFiltersGetObjectsProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "static_filters_get_objects";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::Tag;
    }
};

class TStaticFiltersAddObjectsProcessor: public TAppCommonProcessor<TStaticFiltersAddObjectsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStaticFiltersAddObjectsProcessor, TEmptyConfig>;
public:
    TStaticFiltersAddObjectsProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "static_filters_add_objects";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    TAdministrativeAction::EEntity GetEntityType() const {
        return TAdministrativeAction::EEntity::Tag;
    }

    const ITagsMeta& GetEntitiesManager(const IServerBase* server) const {
        return server->GetAsSafe<NDrive::IServer>().GetDriveAPI()->GetTagsManager().GetTagsMeta();
    }
};
