#pragma once

#include <drive/backend/processors/common_app/db_entities.h>

#include <drive/backend/notifications/manager.h>

class TNotifiersInfoProcessor: public TObjectsInfoProcessor<TNotifierContainer, TNotifiersInfoProcessor> {
private:
    using TBase = TObjectsInfoProcessor<TNotifierContainer, TNotifiersInfoProcessor>;
protected:
    virtual const IDBEntitiesManager<TNotifierContainer>* GetEntitiesManager(const IServerBase* server) const override {
        return server->GetNotifiersManager();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Notifier;
    }
public:
    using TBase::TBase;
};

class TNotifiersUpsertProcessor: public TObjectsUpsertProcessor<TNotifierContainer, TNotifiersUpsertProcessor> {
private:
    using TBase = TObjectsUpsertProcessor<TNotifierContainer, TNotifiersUpsertProcessor>;
protected:
    virtual const IDBEntitiesManager<TNotifierContainer>* GetEntitiesManager(const IServerBase* server) const override {
        return server->GetNotifiersManager();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Notifier;
    }

    virtual bool PreprocessContainer(const TNotifierContainer& container, TUserPermissions::TPtr permissions, TMessagesCollector& errors) const override;
public:
    using TBase::TBase;
};

class TNotifiersRemoveProcessor: public TObjectsRemoveProcessor<TNotifierContainer, TNotifiersRemoveProcessor> {
private:
    using TBase = TObjectsRemoveProcessor<TNotifierContainer, TNotifiersRemoveProcessor>;
protected:
    virtual const IDBEntitiesManager<TNotifierContainer>* GetEntitiesManager(const IServerBase* server) const override {
        return server->GetNotifiersManager();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Notifier;
    }
public:
    using TBase::TBase;
};

class TNotifiersProposeProcessor: public TObjectsProposeProcessor<TNotifierContainer, TNotifiersProposeProcessor> {
private:
    using TBase = TObjectsProposeProcessor<TNotifierContainer, TNotifiersProposeProcessor>;
protected:
    virtual const IDBEntitiesWithPropositionsManager<TNotifierContainer>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetNotifiersManager();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Notifier;
    }
public:
    using TBase::TBase;
};

class TNotifiersConfirmProcessor: public TObjectsConfirmProcessor<TNotifierContainer, TNotifiersConfirmProcessor> {
private:
    using TBase = TObjectsConfirmProcessor<TNotifierContainer, TNotifiersConfirmProcessor>;

protected:
    virtual const IDBEntitiesWithPropositionsManager<TNotifierContainer>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetNotifiersManager();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Notifier;
    }

public:
    using TBase::TBase;
};

class TNotifiersRejectProcessor: public TObjectsRejectProcessor<TNotifierContainer, TNotifiersRejectProcessor> {
private:
    using TBase = TObjectsRejectProcessor<TNotifierContainer, TNotifiersRejectProcessor>;

protected:
    virtual const IDBEntitiesWithPropositionsManager<TNotifierContainer>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetNotifiersManager();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Notifier;
    }

public:
    using TBase::TBase;
};

class TTestNotifierProcessor: public TAppCommonProcessor<TTestNotifierProcessor> {
private:
    using TBase = TAppCommonProcessor<TTestNotifierProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "test_notifier";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TNotifiersListProcessor: public TPropositionsListProcessor<TNotifierContainer, TNotifiersListProcessor> {
private:
    using TBase = TPropositionsListProcessor<TNotifierContainer, TNotifiersListProcessor>;

protected:
    virtual const IDBEntitiesWithPropositionsManager<TNotifierContainer>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetNotifiersManager();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::Notifier;
    }

public:
    using TBase::TBase;
};
