#pragma once

#include <drive/backend/offers/manager.h>
#include <drive/backend/processors/common_app/processor.h>
#include <drive/backend/processors/offers_construction/config.h>

class BuildStandardWithDiscountAreaOfferProcessor
    : public TAppCommonProcessor<BuildStandardWithDiscountAreaOfferProcessor, TNearestObjectsProcessorConfig>
{
private:
    using TBase = TAppCommonProcessor<BuildStandardWithDiscountAreaOfferProcessor, TNearestObjectsProcessorConfig>;
    using TConfig = typename TBase::THandlerConfig;

protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    static TString GetTypeName() {
        return "build_standard_with_discount_area_offer";
    }

public:
    BuildStandardWithDiscountAreaOfferProcessor(const TConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }
};
