#pragma once

#include "config.h"

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/data/chargable.h>
#include <drive/backend/offers/user_context.h>
#include <drive/backend/offers/actions/offer_price.h>

class TOffersHandlerBase: public TCommonServiceAppProcessorBase {
public:
    using TCommonServiceAppProcessorBase::TCommonServiceAppProcessorBase;

protected:
    void FillOffersReport(
        TJsonReport& report,
        const TVector<IOfferReport::TPtr>& offers,
        const TVector<IOfferReport::TPtr>& complementary,
        const TOffersBuildingContext* context,
        const TUserPermissions::TPtr permissions,
        const TMaybe<TDuration> walkingDuration,
        const TSet<TString>& accountNames,
        const TMaybe<TString> creditCard
    );

    void ConstructDelegationLandingReply(
        TJsonReport::TGuard& g,
        TUserPermissions::TPtr permissions,
        TOffersBuildingContext& offersBuildingContext,
        const TVector<IOfferReport::TPtr>& offersAll,
        IOffer::TPtr currentOffer,
        const TBillingSession* billingCompilation,
        NDrive::TInfoEntitySession& session
    );
};

class TCreateOffersProcessor: public TAppCommonProcessor<TCreateOffersProcessor, TNearestObjectsProcessorConfig, TOffersHandlerBase> {
private:
    using TBase = TAppCommonProcessor<TCreateOffersProcessor, TNearestObjectsProcessorConfig, TOffersHandlerBase>;
    using TConfig = typename TBase::THandlerConfig;

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    static TString GetTypeName() {
        return "create_offers";
    }

public:
    TCreateOffersProcessor(const TConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }
};

class TRestoreOfferProcessor: public TAppCommonProcessor<TRestoreOfferProcessor, TEmptyConfig, TOffersHandlerBase> {
private:
    using TBase = TAppCommonProcessor<TRestoreOfferProcessor, TEmptyConfig, TOffersHandlerBase>;
    using TConfig = typename TBase::THandlerConfig;

protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    static TString GetTypeName() {
        return "restore_offer";
    }

public:
    TRestoreOfferProcessor(const TConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }
};
