#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TOffersUpdateProcessor: public TAppCommonProcessor<TOffersUpdateProcessor> {
private:
    using TBase = TAppCommonProcessor<TOffersUpdateProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "offers/update";
    }
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    void UpdateOfferInBooking(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions,
                              const NJson::TJsonValue& requestData, NDrive::TEntitySession& tx,
                              TDBTag& tag);

    void UpdateOfferInSession(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions,
                              const NJson::TJsonValue& requestData, NDrive::TEntitySession& tx);
};
