#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TGetUserPromoCodeProcessor : public TAppCommonProcessor<TGetUserPromoCodeProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TGetUserPromoCodeProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_promo/get";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TGetPromoCodesProcessor: public TAppCommonProcessor<TGetPromoCodesProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TGetPromoCodesProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "promo/get";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCheckPromoCodeProcessor : public TAppCommonProcessor<TCheckPromoCodeProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCheckPromoCodeProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "promo/check";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserHistoryPromoCodeProcessor : public TAppCommonProcessor<TUserHistoryPromoCodeProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserHistoryPromoCodeProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "promo/user_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

// used for processor scheme backward compatibility
class TPromoGenerationSchemeReportingProcessor: public TCommonServiceAppProcessorBase {
private:
    using TBase = TCommonServiceAppProcessorBase;

public:
    using TBase::TBase;

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TPromoGenerationProcessor
    : public TAppCommonProcessor<TPromoGenerationProcessor,
                                 TEmptyConfig,
                                 TCommonServiceAppProcessorBase,
                                 TContextAwareConfig<TPromoGenerationProcessor, TEmptyConfig, TPromoGenerationSchemeReportingProcessor>> {
private:
    using TBase = TAppCommonProcessor<TPromoGenerationProcessor,
                                      TEmptyConfig,
                                      TCommonServiceAppProcessorBase,
                                      TContextAwareConfig<TPromoGenerationProcessor, TEmptyConfig, TPromoGenerationSchemeReportingProcessor>>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "promo/generation";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TMarkPromoGivenOutProcessor: public TAppCommonProcessor<TMarkPromoGivenOutProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TMarkPromoGivenOutProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "promo/give_out";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRemovePromocodeProcessor : public TAppCommonProcessor<TRemovePromocodeProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRemovePromocodeProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "promo/remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TAcceptPromoCodeProcessor: public TAppCommonProcessor<TAcceptPromoCodeProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TAcceptPromoCodeProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "promo/accept";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCreateReferralCodeProcessor : public TAppCommonProcessor<TCreateReferralCodeProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TCreateReferralCodeProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "promo/create_referral_code";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TGetReferralProgramInfoProcessor : public TAppCommonProcessor<TGetReferralProgramInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TGetReferralProgramInfoProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "promo/referral";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class ITemporaryActionTag;

class TGetUserDiscountsProcessor : public TAppCommonProcessor<TGetUserDiscountsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TGetUserDiscountsProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "promo/user_discounts";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    TString GetLimitsReport(const TString& localKey, const ITemporaryActionTag& tag, ELocalization locale, const ILocalization& localization) const;
    TString CreateDescription(const TString& description, const TString& descriptionKey, const TString& limitsKey, ELocalization locale, const ILocalization& localization, const ITemporaryActionTag* tag) const;
    TString CreateDiscountDescription(const TString& description, ELocalization locale, const ILocalization& localization, const ITemporaryActionTag* tag = nullptr) const;
    TString CreatePromoCodeDescription(const TString& description, ELocalization locale, const ILocalization& localization, const ITemporaryActionTag* tag) const;

    virtual bool AddCustomActionsToPermissions() const override {
        return false;
    }
};

class TExternalPromoProcessorConfig {
    R_READONLY(TString, TableName, "external_promo_codes");
public:
    void InitFeatures(const TYandexConfig::Section* section) {
        TableName = section->GetDirectives().Value("TableName", TableName);
    }

    void ToStringFeatures(IOutputStream& os) const {
        os << "TableName: " << TableName << Endl;
    }
};

class TGetExternalPromoReportProcessor : public TAppCommonProcessor<TGetExternalPromoReportProcessor, TExternalPromoProcessorConfig> {
private:
    using TBase = TAppCommonProcessor<TGetExternalPromoReportProcessor, TExternalPromoProcessorConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "external_promo/info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUploadExternalPromoProcessor : public TAppCommonProcessor<TUploadExternalPromoProcessor, TExternalPromoProcessorConfig> {
private:
    using TBase = TAppCommonProcessor<TUploadExternalPromoProcessor, TExternalPromoProcessorConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "external_promo/upload";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
