#pragma once

#include <drive/backend/processors/common_app/fetcher.h>
#include <drive/backend/processors/common_app/processor.h>

class TOrdersSummaryProcessor : public TAppCommonProcessor<TOrdersSummaryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TOrdersSummaryProcessor, TEmptyConfig>;

public:
    TOrdersSummaryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {}

    static TString GetTypeName() {
        return "orders_summary";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    double CalculateUtilization(const double duration, const ui64 realTime, const ui64 count) const;
};

class TMileageSummaryProcessor : public TAppCommonProcessor<TMileageSummaryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TMileageSummaryProcessor, TEmptyConfig>;

public:
    TMileageSummaryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {}

    static TString GetTypeName() {
        return "mileage_summary";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
