#pragma once

#include <drive/backend/processors/common_app/processor.h>

#include <rtline/library/geometry/filter.h>

struct TLandmarkObject {
    TString Name;
    TString Category = "unknown";
    TGeoCoord Coord;

    bool operator==(const TLandmarkObject& other) const;
    void ToJson(NJson::TJsonValue& json) const;
};

class TLandmarksProcessorConfig {
private:
    TString RTLineAPIName;
    ui32 DefaultSearchDistance = 70;
    ui32 DefaultDocsCount = 1;
    ui32 FilterDistance = 100;
    bool DynamicSort = true;
    bool SubwayRouting = false;

public:
    void InitFeatures(const TYandexConfig::Section* section);
    void ToStringFeatures(IOutputStream& os) const;

    const TString& GetRTLineAPIName() const {
        return RTLineAPIName;
    }

    ui32 GetDefaultSearchDistance() const {
        return DefaultSearchDistance;
    }

    ui32 GetDefaultDocsCount() const {
        return DefaultDocsCount;
    }

    ui32 GetFilterDistance() const {
        return FilterDistance;
    }

    bool UseDynamicSort() const {
        return DynamicSort;
    }

    bool UseSubwayRouting() const {
        return SubwayRouting;
    }
};

using TMarkedRouteConfig = TLandmarksProcessorConfig;

class TMarkedRouteProcessor: public TAppCommonProcessor<TMarkedRouteProcessor, TMarkedRouteConfig> {
private:
    using TBase = TAppCommonProcessor<TMarkedRouteProcessor, TMarkedRouteConfig>;

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "marked_route";
    }
};
