#pragma once

#include "config.h"

#include <drive/backend/processors/common_app/db_entities.h>
#include <drive/backend/processors/common_app/processor.h>
#include <drive/backend/rt_background/manager/manager.h>


class TRTBackgroundInfoProcessor: public TAppCommonProcessor<TRTBackgroundInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRTBackgroundInfoProcessor, TEmptyConfig>;
public:
    TRTBackgroundInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "rt_background_info";
    }
    static NDrive::TScheme GetCgiParametersScheme(const IServerBase* /* server */, const TCgiParameters& /* schemeCgi */ = {});

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRTBackgroundUpsertProcessor: public TAppCommonProcessor<TRTBackgroundUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRTBackgroundUpsertProcessor, TEmptyConfig>;
public:
    TRTBackgroundUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "rt_background_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRTBackgroundRemoveProcessor: public TAppCommonProcessor<TRTBackgroundRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TRTBackgroundRemoveProcessor, TEmptyConfig>;
public:
    TRTBackgroundRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "rt_background_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TRTBackgroundProposeProcessor: public TObjectsProposeProcessor<TRTBackgroundProcessContainer, TRTBackgroundProposeProcessor> {
private:
    using TBase = TObjectsProposeProcessor<TRTBackgroundProcessContainer, TRTBackgroundProposeProcessor>;
protected:
    virtual const IDBEntitiesWithPropositionsManager<TRTBackgroundProcessContainer>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetRTBackgroundManager();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::RTBackground;
    }
public:
    using TBase::TBase;
};

class TRTBackgroundConfirmProcessor: public TObjectsConfirmProcessor<TRTBackgroundProcessContainer, TRTBackgroundConfirmProcessor> {
private:
    using TBase = TObjectsConfirmProcessor<TRTBackgroundProcessContainer, TRTBackgroundConfirmProcessor>;
protected:
    virtual const IDBEntitiesWithPropositionsManager<TRTBackgroundProcessContainer>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetRTBackgroundManager();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::RTBackground;
    }
public:
    using TBase::TBase;
};

class TRTBackgroundRejectPropositionProcessor: public TObjectsRejectProcessor<TRTBackgroundProcessContainer, TRTBackgroundRejectPropositionProcessor> {
private:
    using TBase = TObjectsRejectProcessor<TRTBackgroundProcessContainer, TRTBackgroundRejectPropositionProcessor>;
protected:
    virtual const IDBEntitiesWithPropositionsManager<TRTBackgroundProcessContainer>* GetEntitiesManager(const NDrive::IServer* server) const override {
        return server->GetRTBackgroundManager();
    }

    virtual TAdministrativeAction::EEntity GetEntityType() const override {
        return TAdministrativeAction::EEntity::RTBackground;
    }
public:
    using TBase::TBase;
};
