#include "config.h"

#include "processor.h"

#include <util/string/vector.h>

void TDriveServiceAppConfig::DoInit(const TYandexConfig::Section* section) {
    TBase::DoInit(section);
}

void TDriveServiceAppConfig::ToString(IOutputStream& os) const {
    TBase::ToString(os);
}

IRequestProcessor::TPtr TDriveServiceAppConfig::DoConstructAuthProcessor(IReplyContext::TPtr context, IAuthModule::TPtr authModule, const IServerBase* server) const {
    TString uri(context->GetUri());
    if (uri.EndsWith("start")) {
        return new TStartServiceProcessor(*this, context, authModule, server->GetAsPtrSafe<NDrive::IServer>());
    }
    if (uri.EndsWith("finish")) {
        return new TFinishServiceProcessor(*this, context, authModule, server->GetAsPtrSafe<NDrive::IServer>());
    }
    if (uri.EndsWith("commands")) {
        return new TCarCommandProcessor(*this, context, authModule, server->GetAsPtrSafe<NDrive::IServer>());
    }
    if (uri.EndsWith("tag_actions")) {
        return new TListTagsOperationsProcessor(*this, context, authModule, server->GetAsPtrSafe<NDrive::IServer>());
    }
    if (uri.EndsWith("actions")) {
        return new TGetActionsProcessor(*this, context, authModule, server->GetAsPtrSafe<NDrive::IServer>());
    }
    if (uri.EndsWith("car_info")) {
        return new TGetCarInfoProcessor(*this, context, authModule, server->GetAsPtrSafe<NDrive::IServer>());
    }

    Y_ENSURE_EX(false, yexception() << "Unknown path " << uri);
    return nullptr;
}

const TDriveServiceAppConfig::TFactory::TRegistrator<TDriveServiceAppConfig> TDriveServiceAppConfig::RegistratorCarInfo(CAR_INFO);
const TDriveServiceAppConfig::TFactory::TRegistrator<TDriveServiceAppConfig> TDriveServiceAppConfig::RegistratorStartService(START_SERVICING);
const TDriveServiceAppConfig::TFactory::TRegistrator<TDriveServiceAppConfig> TDriveServiceAppConfig::RegistratorFinishService(FINISH_SERVICING);
const TDriveServiceAppConfig::TFactory::TRegistrator<TDriveServiceAppConfig> TDriveServiceAppConfig::RegistratorCommand(SERVICE_CAR_COMMAND);
const TDriveServiceAppConfig::TFactory::TRegistrator<TDriveServiceAppConfig> TDriveServiceAppConfig::RegistratorListActions(LIST_CURRENT_ACTIONS);
const TDriveServiceAppConfig::TFactory::TRegistrator<TDriveServiceAppConfig> TDriveServiceAppConfig::RegistratorTagActions(LIST_TAG_ACTIONS);
