#pragma once

#include <drive/backend/processors/common_app/config.h>

#include <drive/backend/auth/common/auth.h>

#include <rtline/util/types/accessor.h>

const TString CAR_INFO = "service_app_car_info";
const TString START_SERVICING = "service_app_start";
const TString FINISH_SERVICING = "service_app_finish";
const TString SERVICE_CAR_COMMAND = "service_car_command";
const TString LIST_CURRENT_ACTIONS = "list_actions";
const TString LIST_TAG_ACTIONS = "list_tag_actions";


class TDriveServiceAppConfig: public TCommonAppConfig {
private:
    using TBase = TCommonAppConfig;
public:
    TDriveServiceAppConfig(const TString& name)
        : TCommonAppConfig(name)
    {}

    virtual void ToString(IOutputStream& os) const override;

protected:
    virtual void DoInit(const TYandexConfig::Section* section) override;
    virtual IRequestProcessor::TPtr DoConstructAuthProcessor(IReplyContext::TPtr context, IAuthModule::TPtr authModule, const IServerBase* server) const override;

private:
    static const TFactory::TRegistrator<TDriveServiceAppConfig> RegistratorCarInfo;
    static const TFactory::TRegistrator<TDriveServiceAppConfig> RegistratorStartService;
    static const TFactory::TRegistrator<TDriveServiceAppConfig> RegistratorFinishService;
    static const TFactory::TRegistrator<TDriveServiceAppConfig> RegistratorList;
    static const TFactory::TRegistrator<TDriveServiceAppConfig> RegistratorCommand;
    static const TFactory::TRegistrator<TDriveServiceAppConfig> RegistratorListActions;
    static const TFactory::TRegistrator<TDriveServiceAppConfig> RegistratorTagActions;
};
