#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TServiceRouteTag;
class TServiceRoute;
class TServiceTask;
class TCarsFetcher;

class TGetServiceRouteProcessor : public TAppCommonProcessor<TGetServiceRouteProcessor> {
private:
    using TBase = TAppCommonProcessor<TGetServiceRouteProcessor>;

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "get_service_route";
    }

private:
    NJson::TJsonValue BuildOneTaskJsonReport(const TDBTag& tag, TTagDescription::TConstPtr tagDescription, const TServiceTask& task);
    void BuildJsonReport(TJsonReport::TGuard& g, const TServiceRoute& route, const TSet<TString>& droppedTasks, TUserPermissions::TPtr permissions, NDrive::TEntitySession& session);
};
