#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TGetSubordinateWorkersProcessor : public TAppCommonProcessor<TGetSubordinateWorkersProcessor> {
private:
    using TBase = TAppCommonProcessor<TGetSubordinateWorkersProcessor>;

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "get_subordinate_workers";
    }

private:
    const static TString AvailableZonesTagNameSettings;
};


class TPerformForSubordinateWorkerProcessor : public TAppCommonProcessor<TPerformForSubordinateWorkerProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TPerformForSubordinateWorkerProcessor, TEmptyConfig>;

private:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "perform_for_subordinate_worker";
    }
};
