#pragma once

#include <drive/backend/data/scoring/scoring.h>
#include <drive/backend/history_iterator/history_iterator.h>
#include <drive/library/cpp/geocoder/api/client.h>
#include <drive/library/cpp/tracks/projector.h>

namespace NDrive {

    class TAggressionHelper {
    private:
        TSet<TString> AggressiveTagNames;
        const NDrive::TGeocoder* Geocoder;

    public:
        class TAggressiveEvent : public TScoringTraceTag::TEvent {
            using TBase = TScoringTraceTag::TEvent;

        public:
            NThreading::TFuture<NDrive::TGeocoder::TResponse> GeocoderResponse;

        public:
            TAggressiveEvent(const TBase& base);

            NJson::TJsonValue GetReport(TInstant deadline, const TMaybe<NDrive::TTrackProjector>& trackProjector) const;
        };

    public:
        TAggressionHelper(const TSet<TString>& aggressiveTagNames, const NDrive::TGeocoder* geocoder = nullptr);

        const TScoringTraceTag* GetAggressiveTag(const THistoryRideObject& ride) const;

        TVector<TAggressiveEvent> GetAggressiveEvents(const TScoringTraceTag& tag, ELocalization locale) const;
    };

}
