#pragma once

#include <drive/backend/abstract/localization.h>

#include <drive/library/cpp/geocoder/api/client.h>
#include <drive/library/cpp/tracks/quality.h>

namespace NDrive {
    class IServer;

    class TViolationsHelper {
    public:
        using TResponse = TVector<NThreading::TFuture<NDrive::TGeocoder::TResponse>>;
        using TResponses = TVector<TResponse>;

    private:
        const NDrive::TGeocoder* Geocoder;

    public:
        TViolationsHelper(const NDrive::IServer& server);
        void FetchGeocodedRangeCenters(NDrive::TTracksLinker::TResults& results, ELocalization locale, TInstant deadline = TInstant::Zero()) const;
        void FetchGeocodedRangeCenter(NDrive::TTracksLinker::TResult& result, ELocalization locale, TInstant deadline = TInstant::Zero()) const;

    private:
        NThreading::TFuture<NDrive::TGeocoder::TResponse> GetGeocodedCenter(const TSpeedLimitRange& range, ELocalization locale) const;
        TResponses GetTResponsesVector(NDrive::TTracksLinker::TResult& result, ELocalization locale) const;
        TResponse GetTResponseVector(const TSpeedLimitRanges& ranges, ELocalization locale) const;

        void ParseTResponsesVector(const TResponses& responses, NDrive::TTracksLinker::TResult& result, TInstant deadline) const;
        void ParseTResponseVector(const TResponse& response, TSpeedLimitRanges& ranges, TInstant deadline) const;
        void FetchGeocodedCenter(TSpeedLimitRange& range, NThreading::TFuture<NDrive::TGeocoder::TResponse> geocodedResponse, TInstant deadline) const;
    };
}
