#pragma once

#include "config.h"

#include <drive/backend/processors/common_app/processor.h>

class TSettingsHistoryProcessor: public TAppCommonProcessor<TSettingsHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSettingsHistoryProcessor, TEmptyConfig>;

public:
    TSettingsHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "settings_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSettingsInfoProcessor: public TAppCommonProcessor<TSettingsInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSettingsInfoProcessor, TEmptyConfig>;

public:
    TSettingsInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "settings_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TClientSettingsProcessorConfig {
private:
    R_READONLY(TString, CommonPrefix);

public:
    void InitFeatures(const TYandexConfig::Section* section) {
        CommonPrefix = section->GetDirectives().Value("CommonPrefix", CommonPrefix);
    }

    void ToStringFeatures(IOutputStream& os) const {
        os << "CommonPrefix: " << CommonPrefix << Endl;
    }
};

class TClientSettingsInfoProcessor: public TAppCommonProcessor<TClientSettingsInfoProcessor, TClientSettingsProcessorConfig> {
private:
    using TBase = TAppCommonProcessor<TClientSettingsInfoProcessor, TClientSettingsProcessorConfig>;

public:
    TClientSettingsInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "client_settings_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) override;
};

class TSettingsUpsertProcessor: public TAppCommonProcessor<TSettingsUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSettingsUpsertProcessor, TEmptyConfig>;

public:
    TSettingsUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "settings_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSettingsRemoveProcessor: public TAppCommonProcessor<TSettingsRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSettingsRemoveProcessor, TEmptyConfig>;

public:
    TSettingsRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "settings_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSettingsProposeProcessor: public TAppCommonProcessor<TSettingsProposeProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSettingsProposeProcessor, TEmptyConfig>;

public:
    TSettingsProposeProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "settings_propose";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSettingsConfirmProcessor: public TAppCommonProcessor<TSettingsConfirmProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSettingsConfirmProcessor, TEmptyConfig>;

public:
    TSettingsConfirmProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "settings_confirm";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSettingsRejectProcessor: public TAppCommonProcessor<TSettingsRejectProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSettingsRejectProcessor, TEmptyConfig>;

public:
    TSettingsRejectProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "settings_reject";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
