#pragma once

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/drivematics/signals/signal_configurations.h>

TMaybe<TString> StartSessionIfNotStarted(const NDrive::IServer* server,
                                         TJsonReport::TGuard& g,
                                         TUserPermissions::TPtr permissions,
                                         NDrive::TEntitySession& tx,
                                         const TString& carId,
                                         TInstant unixTimestamp);

class TSignalqSessionStarterProcessor : public TAppCommonProcessor<TSignalqSessionStarterProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSignalqSessionStarterProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "signalq_session_starter";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g,
                               TUserPermissions::TPtr permissions,
                               const NJson::TJsonValue& requestData) override;
};

class TSignalqSignalCreaterProcessor : public TAppCommonProcessor<TSignalqSignalCreaterProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSignalqSignalCreaterProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "signalq_signal_creater";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g,
                               TUserPermissions::TPtr permissions,
                               const NJson::TJsonValue& requestData) override;
};

class TSignalqNotifySupport : public TAppCommonProcessor<TSignalqNotifySupport, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSignalqNotifySupport, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "signalq_notify_support";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g,
                               TUserPermissions::TPtr permissions,
                               const NJson::TJsonValue& requestData) override;
};

class TSignalqFleetTraceTagResolutionSet : public TAppCommonProcessor<TSignalqFleetTraceTagResolutionSet, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSignalqFleetTraceTagResolutionSet, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "signalq_fleet_set_resolution";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g,
                               TUserPermissions::TPtr permissions,
                               const NJson::TJsonValue& requestData) override;
};
