#pragma once

#include <drive/backend/processors/common_app/config.h>
#include <drive/backend/processors/common_app/db_entities.h>
#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/cars/status/state_filters.h>

class TStateFiltersHistoryProcessor: public TAppCommonProcessor<TStateFiltersHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStateFiltersHistoryProcessor, TEmptyConfig>;
public:
    TStateFiltersHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "state_filters_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TStateFiltersInfoProcessor: public TAppCommonProcessor<TStateFiltersInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStateFiltersInfoProcessor, TEmptyConfig>;
public:
    TStateFiltersInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "state_filters_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TStateFiltersUpsertProcessor: public TAppCommonProcessor<TStateFiltersUpsertProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStateFiltersUpsertProcessor, TEmptyConfig>;
public:
    TStateFiltersUpsertProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "state_filters_upsert";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TStateFiltersRemoveProcessor: public TAppCommonProcessor<TStateFiltersRemoveProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TStateFiltersRemoveProcessor, TEmptyConfig>;
public:
    TStateFiltersRemoveProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "state_filters_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
