#pragma once

#include <drive/backend/data/user_tags.h>

#include <drive/backend/processors/common_app/config.h>
#include <drive/backend/processors/common_app/processor.h>

class TSubscriptionInfoProcessor
    : public TAppCommonProcessor<TSubscriptionInfoProcessor, TEmptyConfig>
{
private:
    using TBase = TAppCommonProcessor<TSubscriptionInfoProcessor, TEmptyConfig>;

protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    static TString GetTypeName() {
        return "subscription_info";
    }

public:
    TSubscriptionInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }
};

class TSubscriptionUpdateProcessor
    : public TAppCommonProcessor<TSubscriptionUpdateProcessor, TEmptyConfig>
{
private:
    using TBase = TAppCommonProcessor<TSubscriptionUpdateProcessor, TEmptyConfig>;

protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) override;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "subscription_update";
    }
};

class TSubscriptionTaxiScreenProcessor
    : public TAppCommonProcessor<TSubscriptionTaxiScreenProcessor, TEmptyConfig>
{
private:
    using TBase = TAppCommonProcessor<TSubscriptionTaxiScreenProcessor, TEmptyConfig>;

protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& /*requestData*/) override;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "subscription_taxi_screen";
    }

private:
    bool CheckCarsAvailability(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions) const;
    void BuildReport(TJsonReport::TGuard& g,  TUserPermissions::TPtr permissions, const TString& userId, const TDBTag& subscriptionDBTag, TUserSubscriptionTag::TPtr subscriptionTag, bool needGenerate, ui32 maxTaxiRides) const;
    void Generate(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const TString& userId, const TDBTag& subscriptionDBTag, TUserSubscriptionTag::TPtr subscriptionTag) const;
};
