#pragma once

#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/data/user_tags.h>

class TSupportCenterRequestsProcessor : public TAppCommonProcessor<TSupportCenterRequestsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterRequestsProcessor, TEmptyConfig>;

public:
    TSupportCenterRequestsProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_requests";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterDeferRequestProcessor : public TAppCommonProcessor<TSupportCenterDeferRequestProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterDeferRequestProcessor, TEmptyConfig>;

public:
    TSupportCenterDeferRequestProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_defer_request";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterUndeferRequestProcessor : public TAppCommonProcessor<TSupportCenterUndeferRequestProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterUndeferRequestProcessor, TEmptyConfig>;

public:
    TSupportCenterUndeferRequestProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_undefer_request";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterGetCategorizationProcessor : public TAppCommonProcessor<TSupportCenterGetCategorizationProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterGetCategorizationProcessor, TEmptyConfig>;

public:
    TSupportCenterGetCategorizationProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_get_categorization";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterAddCategorizationProcessor : public TAppCommonProcessor<TSupportCenterAddCategorizationProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterAddCategorizationProcessor, TEmptyConfig>;

public:
    TSupportCenterAddCategorizationProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_add_categorization";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterRemoveCategorizationProcessor : public TAppCommonProcessor<TSupportCenterRemoveCategorizationProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterRemoveCategorizationProcessor, TEmptyConfig>;

public:
    TSupportCenterRemoveCategorizationProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_remove_categorization";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterCategorizationHistoryProcessor : public TAppCommonProcessor<TSupportCenterCategorizationHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterCategorizationHistoryProcessor, TEmptyConfig>;

public:
    TSupportCenterCategorizationHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_categorization_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterCategorizationTreeProcessor : public TAppCommonProcessor<TSupportCenterCategorizationTreeProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterCategorizationTreeProcessor, TEmptyConfig>;

public:
    TSupportCenterCategorizationTreeProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_categorization_tree";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterCategorizationTreeEditProcessor : public TAppCommonProcessor<TSupportCenterCategorizationTreeEditProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterCategorizationTreeEditProcessor, TEmptyConfig>;

public:
    TSupportCenterCategorizationTreeEditProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_categorization_tree_edit";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterCallEventProcessor : public TAppCommonProcessor<TSupportCenterCallEventProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterCallEventProcessor, TEmptyConfig>;

public:
    TSupportCenterCallEventProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_call_event";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterWebphoneAuthProcessor : public TAppCommonProcessor<TSupportCenterWebphoneAuthProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterWebphoneAuthProcessor, TEmptyConfig>;

public:
    TSupportCenterWebphoneAuthProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_webphone_auth";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterGetFilteredUserCountProcessor : public TAppCommonProcessor<TSupportCenterGetFilteredUserCountProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterGetFilteredUserCountProcessor, TEmptyConfig>;

public:
    TSupportCenterGetFilteredUserCountProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_users_count";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterForwardExternalMessagesProcessor : public TAppCommonProcessor<TSupportCenterForwardExternalMessagesProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterForwardExternalMessagesProcessor, TEmptyConfig>;

public:
    TSupportCenterForwardExternalMessagesProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_forward_external";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

protected:
    virtual void Parse(const NJson::TJsonValue& requestData) override;

private:
    TString UserId;
    TString ChatId;
    TString ChatType;
    TString Comment;
    TSet<ui64> MessageIds;
};

class TSupportCenterGetLoadBalanceProcessor : public TAppCommonProcessor<TSupportCenterGetLoadBalanceProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterGetLoadBalanceProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "support_center_get_load_balance";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterUpdateLoadBalanceProcessor : public TAppCommonProcessor<TSupportCenterUpdateLoadBalanceProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterUpdateLoadBalanceProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "support_center_update_load_balance";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterPlabackInfoProcessor : public TAppCommonProcessor<TSupportCenterPlabackInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterPlabackInfoProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "support_center_playback_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterPlaybackUpdateProcessor : public TAppCommonProcessor<TSupportCenterPlaybackUpdateProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterPlaybackUpdateProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "support_center_update_palyback";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    static NDrive::TScheme GetRequestDataScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});
};

class TSupportCenterDynamicDistributionProcessor : public TAppCommonProcessor<TSupportCenterDynamicDistributionProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterDynamicDistributionProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "support_center_dynamic_distribution";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterStartCallProcessor : public TAppCommonProcessor<TSupportCenterStartCallProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterStartCallProcessor, TEmptyConfig>;

public:
    TSupportCenterStartCallProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_start_call";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterUpdateCallProcessor : public TAppCommonProcessor<TSupportCenterUpdateCallProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterUpdateCallProcessor, TEmptyConfig>;

public:
    TSupportCenterUpdateCallProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_update_call";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterSyncCallDataProcessor : public TAppCommonProcessor<TSupportCenterSyncCallDataProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterSyncCallDataProcessor, TEmptyConfig>;

public:
    TSupportCenterSyncCallDataProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_sync_call_data";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterLoadCiptTrackProcessor : public TAppCommonProcessor<TSupportCenterLoadCiptTrackProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterLoadCiptTrackProcessor, TEmptyConfig>;

public:
    TSupportCenterLoadCiptTrackProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_load_cipt_track";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSupportCenterBindAudioteleCallProcessor : public TAppCommonProcessor<TSupportCenterBindAudioteleCallProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSupportCenterBindAudioteleCallProcessor, TEmptyConfig>;

public:
    TSupportCenterBindAudioteleCallProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "support_center_audiotele_bind";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUpdateSupportAICallProcessor : public TAppCommonProcessor<TUpdateSupportAICallProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUpdateSupportAICallProcessor, TEmptyConfig>;

public:
    TUpdateSupportAICallProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "update_support_ai_call";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
