#include "processor.h"

#include <drive/backend/database/drive/takeout.h>

void TTakeoutRequestProcessor::Process(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions) {
    Y_UNUSED(permissions);
    TBlob postData = Context->GetBuf();
    TMemoryInput inp(postData.Data(), postData.Size());
    auto postDataStr = inp.ReadAll();
    auto postDataParts = SplitString(postDataStr, "&");

    TString uid = "";
    TString jobId = "";

    for (auto&& param : postDataParts) {
        size_t separatorPos = param.find("=");
        R_ENSURE(separatorPos != TString::npos, HTTP_BAD_REQUEST, "cannot find separator = in " << param);

        auto paramName = param.substr(0, separatorPos);
        auto paramValue = param.substr(separatorPos + 1, param.size() - separatorPos - 1);
        if (paramName == "uid") {
            uid = std::move(paramValue);
        } else if (paramName == "job_id") {
            jobId = std::move(paramValue);
        }
    }

    R_ENSURE(jobId, HTTP_BAD_REQUEST, "cannot find jobId in request payload");
    R_ENSURE(uid, HTTP_BAD_REQUEST, "cannot find uid in request payload");

    Process(g, uid, jobId);
    g.AddReportElement("status", "ok");
    g.SetCode(HTTP_OK);
}

void TTakeoutRequestProcessor::Process(TJsonReport::TGuard& g, const TString& uid, const TString& jobId) {
    auto userId = DriveApi->GetUsersData()->GetUserIdByUid(uid);
    if (!userId) {
        userId = "user-absent";
    }

    TTakeoutRequest request(jobId, userId);
    auto session = DriveApi->GetTakeoutRequests().BuildSession();
    R_ENSURE(DriveApi->GetTakeoutRequests().Insert(request, session) && session.Commit(), ConfigHttpStatus.UnknownErrorStatus, "can't enqueue request");

    g.SetCode(HTTP_OK);
}
