#pragma once

#include <drive/backend/processors/accounts/processor.h>
#include <drive/backend/processors/sessions/base.h>

class TTaxiInfoProcessor : public TAppCommonProcessor<TTaxiInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTaxiInfoProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "taxi_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

template <class T>
class TTaxiSessionBaseProcessor
    : public TAppCommonProcessor<T, TEmptyConfig>
    , public TSessionProcessorTraits<T>
{
private:
    using TBase = TAppCommonProcessor<T, TEmptyConfig>;
    using TSessionProcessor = TSessionProcessorTraits<T>;

public:
    TTaxiSessionBaseProcessor(const typename TBase::THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
        , TSessionProcessor(context, server)
    {
    }
};

class TTaxiSessionItemProcessor : public TTaxiSessionBaseProcessor<TTaxiSessionItemProcessor> {
private:
    using TBase = TTaxiSessionBaseProcessor<TTaxiSessionItemProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "taxi_session_item";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTaxiSessionListProcessor : public TTaxiSessionBaseProcessor<TTaxiSessionListProcessor> {
private:
    using TBase = TTaxiSessionBaseProcessor<TTaxiSessionListProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "taxi_session_list";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TCreateAccountWithPromocodeProcessor : public TAccountsProcessorsBase<TCreateAccountWithPromocodeProcessor, TEmptyConfig> {
private:
    using TBase = TAccountsProcessorsBase<TCreateAccountWithPromocodeProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "create_account_with_promocode";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
