#include "processor.h"

#include <drive/backend/tags/tags_manager.h>
#include <drive/backend/data/tech_dispatch.h>

void TGetTechStationsInfoProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) {
    Y_UNUSED(requestData);
    ReqCheckAdmActions(permissions, TAdministrativeAction::EAction::Observe, TAdministrativeAction::EEntity::TechDispatch);
    auto tx = BuildTx<NSQL::ReadOnly>();
    auto stations = TAssignmentTechDispatchTag::GetStationsInfo(tx, Server);
    R_ENSURE(stations, ConfigHttpStatus.UnknownErrorStatus, "cannot fetch stations info", tx);

    auto description = DriveApi->GetTagsManager().GetTagsMeta().GetDescriptionByName(TOrderTechDispatchTag::TypeName);
    auto orderDescription = Yensured(std::dynamic_pointer_cast<const TOrderTechDispatchTag::TDescription>(description));

    NJson::TJsonValue report;
    for (const auto& station : *stations) {
        NJson::TJsonValue result;
        NJson::InsertField(result, "name", station.GetDescription().GetName());
        NJson::InsertField(result, "service_name", station.GetDescription().GetServiceName());
        NJson::InsertField(result, "service_priority", station.GetDescription().GetServicePriority());
        NJson::InsertField(result, "additional_comment", station.GetDescription().GetAdditionalComment());
        auto& groupJson = result["group_info"];
        for (const auto& group : orderDescription->GetGroupInfos()) {
            NJson::TJsonValue json = NJson::ToJson(group);
            if (auto stationGroup = station.GetDescription().GetRepairGroups().FindPtr(group.GetName())) {
                NJson::InsertField(json, "info", *stationGroup);
            } else {
                NJson::InsertField(json, "info", NJson::TJsonValue{});
            }
            NJson::InsertField(json, "rate", station.GetRates().Value(group.GetName(), 0));
            groupJson.InsertValue(group.GetName(), json);
        }
        if (station.GetErrors().HasMessages()) {
            result["errors"] = station.GetErrors().GetReport();
        }
        report.AppendValue(result);
    }
    g.AddReportElement("stations", std::move(report));
    g.SetCode(HTTP_OK);
}
