#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TTelematicsStatusProcessor: public TAppCommonProcessor<TTelematicsStatusProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTelematicsStatusProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "telematics_status";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTelematicsCarPasswordProcessor: public TAppCommonProcessor<TTelematicsCarPasswordProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTelematicsCarPasswordProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "telematics_car_password";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTelematicsCarStateProcessor: public TAppCommonProcessor<TTelematicsCarStateProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTelematicsCarStateProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "telematics_car_state";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTelematicsFirmwareAddProcessor: public TAppCommonProcessor<TTelematicsFirmwareAddProcessor, TEmptyConfig> {
public:
    using TBase = TAppCommonProcessor<TTelematicsFirmwareAddProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "telematics_firmware_add";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTelematicsFirmwareRemoveProcessor : public TAppCommonProcessor<TTelematicsFirmwareRemoveProcessor, TEmptyConfig> {
public:
    using TBase = TAppCommonProcessor<TTelematicsFirmwareRemoveProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "telematics_firmware_remove";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTelematicsFirmwareListProcessor : public TAppCommonProcessor<TTelematicsFirmwareListProcessor, TEmptyConfig> {
public:
    using TBase = TAppCommonProcessor<TTelematicsFirmwareListProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "telematics_firmware_list";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTelematicsHistoryProcessor : public TAppCommonProcessor<TTelematicsHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTelematicsHistoryProcessor, TEmptyConfig>;

public:
    TTelematicsHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {}

    static TString GetTypeName() {
        return "telematics_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    void Process1(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions);
    void Process2(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions);
};

class TTelematicsPusherProcessor : public TAppCommonProcessor<TTelematicsPusherProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTelematicsPusherProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "telematics_pusher";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTelematicsEventPusherProcessor : public TAppCommonProcessor<TTelematicsEventPusherProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTelematicsEventPusherProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "telematics_event_pusher";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTelematicsConfigurationGetProcessor: public TAppCommonProcessor<TTelematicsConfigurationGetProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTelematicsConfigurationGetProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "telematics_configuration_get";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTelematicsConfigurationSetProcessor: public TAppCommonProcessor<TTelematicsConfigurationSetProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTelematicsConfigurationSetProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "telematics_configuration_set";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
