#pragma once
#include <drive/backend/processors/common_app/config.h>
#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/processor/processor.h>

#include <drive/library/cpp/searchserver/replier.h>

#include <rtline/api/graph/metrics/quality.h>

class TTracesInfoProcessorConfig: public TCommonAppConfig {
private:
    using TBase = TCommonAppConfig;

private:
    TString TracksApiName = "drive_graph";

private:
    static TFactory::TRegistrator<TTracesInfoProcessorConfig> Registrator;

protected:
    virtual void DoInit(const TYandexConfig::Section* section) override;
public:
    using TBase::TBase;

    virtual IRequestProcessor::TPtr DoConstructAuthProcessor(IReplyContext::TPtr context, IAuthModule::TPtr authModule, const IServerBase* server) const override;
    virtual void ToString(IOutputStream& os) const override;

    const TString& GetTracksApiName() const {
        return TracksApiName;
    }
};

class TTracesInfoProcessor: public TCommonServiceAppProcessorBase {
private:
    using TBase = TCommonServiceAppProcessorBase;
public:
    TTracesInfoProcessor(const TTracesInfoProcessorConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const IServerBase* server)
        : TBase(config, context, authModule, server)
        , Config(config)
    {
    }

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
private:
    const TTracesInfoProcessorConfig& Config;
};
