#include "processor.h"

void TObjectIdMatcherHistoryProcessor::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) {
    Y_UNUSED(requestData);
    ReqCheckAdmActions(permissions, TAdministrativeAction::EAction::ObserveStructure, TAdministrativeAction::EEntity::Car);
    const TCgiParameters& cgi = Context->GetCgiParameters();
    ui32 lastEventId = GetValue<ui32>(cgi, "last_event_id", 0).GetOrElse(0);
    auto actuality = TInstant::Now();

    auto tx = BuildTx<NSQL::TTransactionTraits(NSQL::ETransactionTraits::ReadOnly)>();
    NSQL::TQueryOptions options;
    options.SetOrderBy({ "history_event_id" });
    auto optionalEvents = DriveApi->GetCarManager().GetHistoryManager().GetEvents<TDriveCarInfo>(lastEventId, tx, options);
    R_ENSURE(optionalEvents, {}, "cannot GetEvents", tx);

    THashMap<TString, TString> imeiHistory;
    TVector<NDrive::TMatcherEvent> carInfo;
    for (const auto& event : *optionalEvents) {
        auto currentObjectId = event.GetId();
        auto imei = event.GetIMEI();
        ui32 historyEventId = event.GetHistoryEventId();
        lastEventId = std::max(lastEventId, historyEventId);

        if (event.GetHistoryAction() == EObjectHistoryAction::Remove) {
            imeiHistory.erase(currentObjectId);
            carInfo.push_back(NDrive::TMatcherEvent(event));
        } else if (imeiHistory[currentObjectId] != imei) {
            imeiHistory[currentObjectId] = imei;
            carInfo.push_back(NDrive::TMatcherEvent(event));
        }
    }

    NJson::TJsonValue events;
    if (lastEventId == 0) {
        auto carsInfo = DriveApi->GetCarManager().FetchInfo();
        for (const auto& info : carsInfo) {
            events.AppendValue(NJson::ToJson(NDrive::TMatcherEvent(0, EObjectHistoryAction::Unknown, info.second.GetId(), info.second.GetIMEI(), TInstant::Zero())));
        }
    }

    for (const auto& info : carInfo) {
        events.AppendValue(NJson::ToJson(info));
    }

    g.AddReportElement("events", std::move(events));
    g.AddReportElement("last_event_id", lastEventId);
    g.AddReportElement("actuality", actuality.Seconds());

    g.SetCode(HTTP_OK);
}
