#pragma once

#include <drive/backend/tracks/object_id_matcher/matcher.h>
#include <drive/backend/processors/common_app/processor.h>

class TObjectIdMatcherHistoryProcessor
    : public TAppCommonProcessor<TObjectIdMatcherHistoryProcessor, TEmptyConfig>
{
private:
    using TBase = TAppCommonProcessor<TObjectIdMatcherHistoryProcessor, TEmptyConfig>;

protected:
    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

public:
    static TString GetTypeName() {
        return "object_id_matcher_history";
    }

    TObjectIdMatcherHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }
};
