#pragma once

#include <drive/backend/processors/common_app/config.h>
#include <drive/backend/processors/common_app/processor.h>

class TTailProcessorConfig: public TCommonAppConfig {
private:
    using TBase = TCommonAppConfig;

private:
    TString TracksApiName = "drive_graph";
    TString LinkerApiName = "default-linker";


protected:
    virtual void DoInit(const TYandexConfig::Section* section) override;

public:
    using TBase::TBase;

    virtual IRequestProcessor::TPtr DoConstructAuthProcessor(IReplyContext::TPtr context, IAuthModule::TPtr authModule, const IServerBase* server) const override;

    virtual void ToString(IOutputStream& os) const override;

    const TString& GetTracksApiName() const {
        return TracksApiName;
    }
    const TString& GetLinkerApiName() const {
        return LinkerApiName;
    }
};

class TTailProcessor: public TCommonServiceAppProcessorBase {
public:
    TTailProcessor(const TTailProcessorConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const IServerBase* server)
        : TCommonServiceAppProcessorBase(config, context, authModule, server)
        , Config(config)
    {
    }

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& /*g*/, TUserPermissions::TPtr /*permissions*/, const NJson::TJsonValue& /*requestData*/);

private:
    const TTailProcessorConfig& Config;
};
