#pragma once

#include <drive/backend/processors/common_app/config.h>
#include <drive/backend/processors/common_app/data_check.h>
#include <drive/backend/processors/common_app/processor.h>
#include <drive/backend/user_insurance/entities.h>

class TUserInsuranceCalculateProcessor: public TAppCommonProcessor<TUserInsuranceCalculateProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserInsuranceCalculateProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_insurance_calculate";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    void Parse(const NJson::TJsonValue& requestData) override;

    static NDrive::TScheme GetRequestDataScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});

private:
    R_READONLY(NDrive::NRenins::NKasko::TAutoData, CarData);
    R_READONLY(NDrive::NRenins::TKaskoData, KaskoData);
};

class TUserInsuranceOrderProcessor: public TAppCommonProcessor<TUserInsuranceOrderProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserInsuranceOrderProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_insurance_order";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    void Parse(const NJson::TJsonValue& requestData) override;

    static NDrive::TScheme GetRequestDataScheme(const IServerBase* server, const TCgiParameters& schemeCgi = {});

private:
    R_FIELD(TVector<NDrive::NRenins::NKasko::TDriverOrderStartData>, AdditionalDrivers);
};

class TUserInsuranceStatusProcessor: public TAppCommonProcessor<TUserInsuranceStatusProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserInsuranceStatusProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_insurance_status";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserInsuranceCarProcessor: public TAppCommonProcessor<TUserInsuranceCarProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserInsuranceCarProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_insurance_car";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserInsuranceDriverProcessor: public TAppCommonProcessor<TUserInsuranceDriverProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserInsuranceDriverProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_insurance_driver";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserInsurancePresetsProcessor: public TAppCommonProcessor<TUserInsurancePresetsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserInsurancePresetsProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_insurance_presets";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserInsuranceFixDataProcessor: public TAppCommonProcessor<TUserInsuranceFixDataProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserInsuranceFixDataProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_insurance_fix_data";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    void Parse(const NJson::TJsonValue& requestData) override;

private:
    R_READONLY(NDrive::NRenins::TKaskoData, KaskoData);
};
