#pragma once

#include <drive/backend/processors/common_app/config.h>
#include <drive/backend/processors/common_app/processor.h>

#include <drive/backend/data/dictionary_tags.h>

class TSetDefaultCardProcessor: public TAppCommonProcessor<TSetDefaultCardProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSetDefaultCardProcessor, TEmptyConfig>;
public:
    TSetDefaultCardProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {
    }

    static TString GetTypeName() {
        return "set_card";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TSetPersonalSettingsProcessorConfig {
public:
    const TString& GetTagNameSetting() const {
        return TagNameSetting;
    }

    void InitFeatures(const TYandexConfig::Section* section);
    void ToStringFeatures(IOutputStream& os) const;

private:
    TString TagNameSetting = NDrive::UserSettingsTagNameSetting;
};

class TSetPersonalSettingsProcessor: public TAppCommonProcessor<TSetPersonalSettingsProcessor, TSetPersonalSettingsProcessorConfig> {
private:
    using TBase = TAppCommonProcessor<TSetPersonalSettingsProcessor, TSetPersonalSettingsProcessorConfig>;
public:
    TSetPersonalSettingsProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "set_personal_settings";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};


class TGetPersonalSettingsProcessor : public TAppCommonProcessor<TGetPersonalSettingsProcessor, TSetPersonalSettingsProcessorConfig> {
private:
    using TBase = TAppCommonProcessor<TGetPersonalSettingsProcessor, TSetPersonalSettingsProcessorConfig>;
public:
    TGetPersonalSettingsProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {}

    static TString GetTypeName() {
        return "get_personal_settings";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TGetDebtInfoProcessor : public TAppCommonProcessor<TGetDebtInfoProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TGetDebtInfoProcessor, TEmptyConfig>;
public:
    TGetDebtInfoProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server) {}

    static TString GetTypeName() {
        return "personal_debt_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
