LIBRARY()

OWNER(g:drive-backend)

SRCS(
    GLOBAL insurance.cpp
    GLOBAL processor.cpp
    GLOBAL user_data.cpp
    favourite_address_advisor.cpp
    sessions_context.cpp
    user_context.cpp
)

PEERDIR(
    drive/backend/abstract
    drive/backend/auth/blackbox2
    drive/backend/billing/accounts
    drive/backend/billing/trust
    drive/backend/common
    drive/backend/data
    drive/backend/data/scoring
    drive/backend/database
    drive/backend/database/drive
    drive/backend/database/transaction
    drive/backend/device_snapshot
    drive/backend/history_iterator
    drive/backend/insurance/task
    drive/backend/notifications/mail
    drive/backend/notifications/push
    drive/backend/offers/actions
    drive/backend/processors/car_scanner
    drive/backend/processors/common_app
    drive/backend/processors/sessions
    drive/backend/processors/user_app/proto
    drive/backend/report
    drive/backend/roles
    drive/backend/saas
    drive/backend/signalq/signals
    drive/backend/tags
    drive/backend/tracks
    drive/backend/user_insurance
    drive/library/cpp/datasync
    drive/library/cpp/raw_text
    drive/library/cpp/renins
    drive/library/cpp/scheme
    drive/library/cpp/threading
    drive/telematics/protocol
    drive/telematics/server/tasks
    library/cpp/cache
    rtline/library/geometry
    rtline/library/json
    rtline/util/algorithm
    rtline/util/types
)

GENERATE_ENUM_SERIALIZATION(favourite_address_advisor.h)

END()
