#pragma once

#include <drive/backend/processors/common_app/processor.h>
#include <drive/backend/users/user_documents_check.h>
#include <drive/backend/data/dictionary_tags.h>
#include <drive/backend/user_document_photos/manager.h>

class TSetUserDocumentsCheckStatusProcessor: public TAppCommonProcessor<TSetUserDocumentsCheckStatusProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TSetUserDocumentsCheckStatusProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    TSetUserDocumentsCheckStatusProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "set_user_documents_check_status";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TGetUserDocumentsCheckProcessor: public TAppCommonProcessor<TGetUserDocumentsCheckProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TGetUserDocumentsCheckProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    TGetUserDocumentsCheckProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "get_user_documents_check";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    void MergeWithRegistrationTag(TVector<TUserDocumentsCheck>& checks, const TString& userId, const TSet<TString>& types, NDrive::TEntitySession& session) const;

private:
    bool MergeRegistrationTag;
    TMaybe<TRegistrationTagInfo> RegistrationTagInfo;
};

class TGetUserDocumentsCheckHistoryProcessor: public TAppCommonProcessor<TGetUserDocumentsCheckHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TGetUserDocumentsCheckHistoryProcessor, TEmptyConfig>;
    using THistoryEvent = TUserDocumentsChecksHistoryManager::TCheckHistoryEvent;
    using TTypesByIds = TMap<TString, TSet<NUserDocument::EType>>;
    using TPathsByIds = TMap<TString, TMap<TString, NJson::TJsonValue>>;

public:
    using TBase::TBase;

    TGetUserDocumentsCheckHistoryProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "get_user_documents_check_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

private:
    TVector<THistoryEvent> BuildEventsFromTagHistory(const TString& userId, const TString& type, const TInstant& since, NDrive::TEntitySession& session) const;
    bool MergeEventsWithTagHistory(TVector<THistoryEvent>& events, const TString& userId, const TString& type, const TInstant& since, NDrive::TEntitySession& session) const;

    TPathsByIds GetPhotosAccessPaths(const TTypesByIds& typeBySecretId, const TDocumentPhotosManager& photoManager, NDrive::TEntitySession& session) const;

private:
    bool EnrichWithPhotoPaths;
    TUserDocumentsChecksManager::TChecksGenericMap GenericTypeMap;

    bool MergeRegistrationTag;
    TMaybe<TRegistrationTagInfo> RegistrationTagInfo;
};
